/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.editor;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.editor.Editor;
import org.primefaces.renderkit.CoreRenderer;

public class EditorRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Editor editor = (Editor)component;
        String clientId = editor.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            editor.setSubmittedValue(params.get(clientId));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Editor editor = (Editor)component;
        this.encodeMarkup(facesContext, editor);
        this.encodeScript(facesContext, editor);
    }

    protected void encodeMarkup(FacesContext facesContext, Editor editor) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = editor.getClientId(facesContext);
        String value = (String)editor.getValue();
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (value != null) {
            writer.write(value);
        }
        writer.endElement("textarea");
    }

    private void encodeScript(FacesContext facesContext, Editor editor) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = editor.getClientId(facesContext);
        String widgetVar = editor.resolveWidgetVar();
        writer.startElement("script", (UIComponent)editor);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(widgetVar + " = new PrimeFaces.widget.Editor('" + clientId + "',{");
        writer.write("lazy:" + editor.isLazy());
        if (editor.getControls() != null) {
            writer.write(",controls:'" + editor.getControls() + "'");
        }
        if (editor.getWidth() != Integer.MIN_VALUE) {
            writer.write(",width:" + editor.getWidth());
        }
        if (editor.getHeight() != Integer.MIN_VALUE) {
            writer.write(",height:" + editor.getHeight());
        }
        if (editor.isDisabled()) {
            writer.write(",disabled:true");
        }
        writer.write("});});");
        writer.endElement("script");
    }
}

