/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.graphicimage;

import java.io.IOException;
import java.util.UUID;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.HTML;

public class GraphicImageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        GraphicImage image = (GraphicImage)component;
        String clientId = image.getClientId(context);
        String imageSrc = image.getValue() == null ? "" : this.getImageSrc(context, image);
        writer.startElement("img", (UIComponent)image);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("src", (Object)imageSrc, null);
        if (image.getAlt() == null) {
            writer.writeAttribute("alt", (Object)"", null);
        }
        if (image.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)image.getStyleClass(), "styleClass");
        }
        this.renderPassThruAttributes(context, (UIComponent)image, HTML.IMG_ATTRS);
        writer.endElement("img");
    }

    protected String getImageSrc(FacesContext context, GraphicImage image) {
        String src = null;
        Object value = image.getValue();
        if (value instanceof StreamedContent) {
            ValueExpression valueVE = image.getValueExpression("value");
            String expressionString = valueVE.getExpressionString();
            String expressionParamValue = expressionString.substring(2, expressionString.length() - 1);
            String actionURL = this.getActionURL(context);
            StringBuilder builder = new StringBuilder();
            char queryChar = actionURL.contains("?") ? (char)'&' : '?';
            builder.append(actionURL).append(queryChar).append("primefacesDynamicContent").append("=").append(expressionParamValue);
            for (UIComponent kid : image.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)kid;
                builder.append("&").append(param.getName()).append("=").append(param.getValue());
            }
            src = builder.toString();
        } else {
            src = this.getResourceURL(context, (String)value);
        }
        if (!image.isCache()) {
            src = src + (src.contains("?") ? "&" : "?");
            src = src + "primefaces_image=" + UUID.randomUUID().toString();
        }
        return src;
    }
}

