/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.password;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.password.Password;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class PasswordRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Password password = (Password)component;
        if (password.isDisabled() || password.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)password);
        String clientId = password.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            password.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Password password = (Password)component;
        this.encodeMarkup(context, password);
        this.encodeScript(context, password);
    }

    protected void encodeScript(FacesContext context, Password password) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        boolean feedback = password.isFeedback();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write(password.resolveWidgetVar() + " = new PrimeFaces.widget.Password('" + clientId + "', {");
        writer.write("feedback:" + feedback);
        if (feedback) {
            if (password.getMinLength() != 8) {
                writer.write(",length:" + password.getMinLength());
            }
            if (password.isInline()) {
                writer.write(",flat:true");
            }
            if (password.getLevel() != 1) {
                writer.write(",type: " + password.getLevel());
            }
            if (password.getPromptLabel() != null) {
                writer.write(",promptLabel:'" + password.getPromptLabel() + "'");
            }
            if (password.getWeakLabel() != null) {
                writer.write(",weakLabel:'" + password.getWeakLabel() + "'");
            }
            if (password.getGoodLabel() != null) {
                writer.write(",goodLabel:'" + password.getGoodLabel() + "'");
            }
            if (password.getStrongLabel() != null) {
                writer.write(",strongLabel:'" + password.getStrongLabel() + "'");
            }
            if (password.getOnshow() != null) {
                writer.write(",onShow:" + password.getOnshow());
            }
            if (password.getOnhide() != null) {
                writer.write(",onHide:" + password.getOnhide());
            }
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)password);
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, Password password) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        String styleClass = password.getStyleClass();
        styleClass = styleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + styleClass;
        writer.startElement("input", (UIComponent)password);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"password", null);
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)password);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)password, HTML.INPUT_TEXT_ATTRS);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.endElement("input");
    }
}

