/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.security.Principal;
import javax.faces.context.FacesContext;

public class SecurityUtils {
    private SecurityUtils() {
    }

    public static boolean ifGranted(String role) {
        return FacesContext.getCurrentInstance().getExternalContext().isUserInRole(role);
    }

    public static boolean ifAllGranted(String value) {
        String[] roles = value.split(",");
        boolean isAuthorized = false;
        for (String role : roles) {
            if (!SecurityUtils.ifGranted(role)) {
                isAuthorized = false;
                break;
            }
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static boolean ifAnyGranted(String value) {
        String[] roles = value.split(",");
        boolean isAuthorized = false;
        for (String role : roles) {
            if (!SecurityUtils.ifGranted(role)) continue;
            isAuthorized = true;
            break;
        }
        return isAuthorized;
    }

    public static boolean ifNoneGranted(String value) {
        String[] roles = value.split(",");
        boolean isAuthorized = false;
        for (String role : roles) {
            if (SecurityUtils.ifGranted(role)) {
                isAuthorized = false;
                break;
            }
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static String remoteUser() {
        return FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
    }

    public static Principal userPrincipal() {
        return FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
    }
}

