/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandbutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class CommandButtonRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        CommandButton button = (CommandButton)component;
        if (button.isDisabled()) {
            return;
        }
        String param = component.getClientId(facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        CommandButton button = (CommandButton)component;
        if (button.getType() == null) {
            button.setType("submit");
        }
        this.encodeMarkup(facesContext, button);
        this.encodeScript(facesContext, button);
    }

    protected void encodeMarkup(FacesContext facesContext, CommandButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        String type = button.getType();
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        if (button.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)button.getStyleClass(), "styleClass");
        }
        String onclick = button.getOnclick();
        if (!type.equals("reset") && !type.equals("button")) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)button);
            if (form == null) {
                throw new FacesException("CommandButton : \"" + clientId + "\" must be inside a form element");
            }
            String formClientId = form.getClientId(facesContext);
            String request = button.isAjax() ? this.buildAjaxRequest(facesContext, button, formClientId, clientId) + "return false;" : this.buildNonAjaxRequest(facesContext, button, formClientId);
            String string = onclick = onclick != null ? onclick + ";" + request : request;
        }
        if (!this.isValueBlank(onclick)) {
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.getValue() != null) {
            writer.write(button.getValue().toString());
        } else if (button.getImage() != null) {
            writer.write("ui-button");
        }
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext facesContext, CommandButton button) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = button.getClientId(facesContext);
        String type = button.getType();
        boolean hasValue = button.getValue() != null;
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(button.resolveWidgetVar() + " = new PrimeFaces.widget.CommandButton('" + clientId + "', {");
        if (type.equals("image") || button.getImage() != null) {
            writer.write("text:" + hasValue);
            writer.write(",icons:{");
            writer.write("primary:'" + button.getImage() + "'");
            writer.write("}");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected String buildNonAjaxRequest(FacesContext facesContext, CommandButton button, String formId) {
        boolean hasParam = false;
        StringBuilder request = new StringBuilder();
        for (UIComponent component : button.getChildren()) {
            if (!(component instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)component;
            if (!hasParam) {
                request.append("PrimeFaces");
                hasParam = true;
            }
            request.append(this.addSubmitParam(formId, param.getName(), String.valueOf(param.getValue())));
        }
        request.append(";");
        return request.toString();
    }
}

