/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.contextmenu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.contextmenu.ContextMenu;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menuitem.MenuItem;

public class ContextMenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ContextMenu menu = (ContextMenu)abstractMenu;
        String widgetVar = menu.resolveWidgetVar();
        String clientId = menu.getClientId(context);
        String trigger = this.findTrigger(context, menu);
        writer.startElement("script", (UIComponent)menu);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(widgetVar + " = new PrimeFaces.widget.ContextMenu('" + clientId + "',");
        writer.write("{target:" + trigger);
        writer.write(",zindex:" + menu.getZindex());
        writer.write(",animated:'" + menu.getEffect() + "'");
        if (menu.getEffectDuration() != 400) {
            writer.write(",showDuration:" + menu.getEffectDuration());
            writer.write(",hideDuration:" + menu.getEffectDuration());
        }
        if (menu.getStyleClass() != null) {
            writer.write(",styleClass:'" + menu.getStyleClass() + "'");
        }
        if (menu.getStyle() != null) {
            writer.write(",style:'" + menu.getStyle() + "'");
        }
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ContextMenu menu = (ContextMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        for (UIComponent child : menu.getChildren()) {
            MenuItem item = (MenuItem)child;
            if (!item.isRendered()) continue;
            writer.startElement("li", null);
            this.encodeMenuItem(context, item);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("span");
    }

    protected String findTrigger(FacesContext context, ContextMenu menu) {
        String trigger = null;
        String _for = menu.getFor();
        if (_for != null) {
            UIComponent forComponent = menu.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component '" + _for + "' in view.");
            }
            return "'" + forComponent.getClientId(context) + "'";
        }
        trigger = "document";
        return trigger;
    }
}

