/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inplace;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.primefaces.component.inplace.Inplace;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class InplaceRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Inplace inplace = (Inplace)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(inplace.getClientId(context) + "_save")) {
            FacesEvent event = new FacesEvent((UIComponent)inplace){

                public boolean isAppropriateListener(FacesListener fl) {
                    return false;
                }

                public void processListener(FacesListener fl) {
                    throw new UnsupportedOperationException();
                }

                public PhaseId getPhaseId() {
                    return PhaseId.INVOKE_APPLICATION;
                }
            };
            inplace.queueEvent(event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Inplace inplace = (Inplace)component;
        this.encodeMarkup(context, inplace);
        this.encodeScript(context, inplace);
    }

    protected void encodeMarkup(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inplace.getClientId(context);
        String userStyleClass = inplace.getStyleClass();
        String userStyle = inplace.getStyle();
        String styleClass = userStyleClass == null ? "ui-inplace" : "ui-inplace " + userStyleClass;
        boolean disabled = inplace.isDisabled();
        String displayClass = disabled ? "ui-inplace-display-disabled" : "ui-inplace-display";
        boolean validationFailed = context.isValidationFailed();
        String displayStyle = validationFailed ? "none" : "inline";
        String contentStyle = validationFailed ? "inline" : "none";
        writer.startElement("span", (UIComponent)inplace);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (userStyle != null) {
            writer.writeAttribute("style", (Object)userStyle, "id");
        }
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_display"), "id");
        writer.writeAttribute("class", (Object)displayClass, null);
        writer.writeAttribute("style", (Object)("display:" + displayStyle), null);
        writer.write(this.getLabelToRender(context, inplace));
        writer.endElement("span");
        if (!inplace.isDisabled()) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
            writer.writeAttribute("class", (Object)"ui-inplace-content", null);
            writer.writeAttribute("style", (Object)("display:" + contentStyle), null);
            this.renderChildren(context, (UIComponent)inplace);
            if (inplace.isEditor()) {
                this.encodeEditor(context, inplace);
            }
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    protected String getLabelToRender(FacesContext context, Inplace inplace) {
        String label = inplace.getLabel();
        String emptyLabel = inplace.getEmptyLabel();
        if (label != null) {
            return label;
        }
        String value = ComponentUtils.getStringValueToRender(context, (UIComponent)inplace.getChildren().get(0));
        if (value == null || this.isValueBlank(value)) {
            if (emptyLabel != null) {
                return emptyLabel;
            }
            return "";
        }
        return value;
    }

    protected void encodeScript(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inplace.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(inplace.resolveWidgetVar() + " = new PrimeFaces.widget.Inplace('" + clientId + "', {");
        writer.write("effect:'" + inplace.getEffect() + "'");
        writer.write(",effectSpeed:'" + inplace.getEffectSpeed() + "'");
        writer.write(",event:'" + inplace.getEvent() + "'");
        if (inplace.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (inplace.isEditor()) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)inplace);
            if (form == null) {
                throw new FacesException("Inplace : \"" + inplace.getClientId(context) + "\" must be inside a form element");
            }
            writer.write(",editor:true");
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",formId:'" + form.getClientId(context) + "'");
            String onEditUpdate = inplace.getOnEditUpdate();
            if (onEditUpdate != null) {
                writer.write(",onEditUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)inplace, onEditUpdate) + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeEditor(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(inplace.getClientId(context) + "_editor"), null);
        writer.writeAttribute("class", (Object)"ui-inplace-editor", null);
        this.encodeButton(context, inplace, inplace.getSaveLabel(), "ui-inplace-save");
        this.encodeButton(context, inplace, inplace.getCancelLabel(), "ui-inplace-cancel");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, Inplace inplace, String label, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write(label);
        writer.endElement("button");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

