/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.component.datatable.DataTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Exporter {
    public abstract void export(FacesContext var1, DataTable var2, String var3, boolean var4, int[] var5, String var6, MethodExpression var7, MethodExpression var8) throws IOException;

    protected List<UIColumn> getColumnsToExport(UIData table, int[] excludedColumns) {
        ArrayList<UIColumn> allColumns = new ArrayList<UIColumn>();
        ArrayList<UIColumn> columnsToExport = new ArrayList<UIColumn>();
        for (UIComponent component : table.getChildren()) {
            if (!(component instanceof UIColumn)) continue;
            allColumns.add((UIColumn)component);
        }
        if (excludedColumns == null) {
            return allColumns;
        }
        for (int i = 0; i < allColumns.size(); ++i) {
            if (Arrays.binarySearch(excludedColumns, i) >= 0) continue;
            columnsToExport.add((UIColumn)allColumns.get(i));
        }
        allColumns = null;
        return columnsToExport;
    }

    protected String exportValue(FacesContext context, UIComponent component) {
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return null;
        }
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(context, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(context.getELContext())) != null && (converterForType = context.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(context, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }
}

