/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtextarea;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputtextarea.InputTextarea;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputTextareaRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputTextarea inputTextarea = (InputTextarea)component;
        if (inputTextarea.isDisabled() || inputTextarea.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputTextarea);
        String clientId = inputTextarea.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        inputTextarea.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputTextarea inputTextarea = (InputTextarea)component;
        this.encodeMarkup(context, inputTextarea);
        this.encodeScript(context, inputTextarea);
    }

    protected void encodeScript(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        boolean autoResize = inputTextarea.isAutoResize();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(inputTextarea.resolveWidgetVar() + " = new PrimeFaces.widget.InputTextarea('" + clientId + "', {");
        writer.write("autoResize:" + autoResize);
        writer.write(",maxHeight:" + inputTextarea.getMaxHeight());
        writer.write(",effectDuration:" + inputTextarea.getEffectDuration());
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputTextarea);
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, InputTextarea inputTextarea) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputTextarea.getClientId(context);
        String styleClass = inputTextarea.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + styleClass;
        if (inputTextarea.isAutoResize()) {
            styleClass = styleClass + " ui-inputtextarea-resizable";
        }
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        this.renderPassThruAttributes(context, (UIComponent)inputTextarea, HTML.INPUT_TEXTAREA_ATTRS);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)inputTextarea);
        if (valueToRender != null) {
            writer.writeText((Object)valueToRender, "value");
        }
        writer.endElement("textarea");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        InputTextarea inputTextarea = (InputTextarea)component;
        String value = (String)submittedValue;
        Converter converter = inputTextarea.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)inputTextarea, value);
        }
        ValueExpression ve = inputTextarea.getValueExpression("value");
        if (ve != null) {
            Class valueType = ve.getType(context.getELContext());
            Converter converterForType = context.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsObject(context, (UIComponent)inputTextarea, value);
            }
        }
        return value;
    }
}

