/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.picklist;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.picklist.PickList;
import org.primefaces.model.DualListModel;
import org.primefaces.renderkit.CoreRenderer;

public class PickListRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        PickList pickList = (PickList)component;
        String clientId = pickList.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String sourceParam = clientId + "_source";
        String targetParam = clientId + "_target";
        if (params.containsKey(sourceParam) && params.containsKey(targetParam)) {
            pickList.setSubmittedValue(new String[]{(String)params.get(sourceParam), (String)params.get(targetParam)});
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        PickList pickList = (PickList)component;
        this.encodeMarkup(facesContext, pickList);
        this.encodeScript(facesContext, pickList);
    }

    protected void encodeMarkup(FacesContext context, PickList pickList) throws IOException {
        boolean hasTargetCaption;
        boolean hasSourceCaption;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = pickList.getClientId(context);
        DualListModel model = (DualListModel)pickList.getValue();
        String styleClass = pickList.getStyleClass();
        styleClass = styleClass == null ? "ui-picklist ui-widget" : "ui-picklist ui-widget " + styleClass;
        writer.startElement("table", (UIComponent)pickList);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (pickList.getStyle() != null) {
            writer.writeAttribute("style", (Object)pickList.getStyle(), null);
        }
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (pickList.isShowSourceControls()) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-picklist-source-controls", null);
            this.encodeButton(context, pickList, pickList.getMoveUpLabel(), "ui-picklist-button ui-picklist-button-move-up");
            this.encodeButton(context, pickList, pickList.getMoveTopLabel(), "ui-picklist-button ui-picklist-button-move-top");
            this.encodeButton(context, pickList, pickList.getMoveDownLabel(), "ui-picklist-button ui-picklist-button-move-down");
            this.encodeButton(context, pickList, pickList.getMoveBottomLabel(), "ui-picklist-button ui-picklist-button-move-bottom");
            writer.endElement("td");
        }
        writer.startElement("td", null);
        UIComponent sourceCaption = pickList.getFacet("sourceCaption");
        boolean bl = hasSourceCaption = sourceCaption != null;
        if (hasSourceCaption) {
            this.encodeCaption(context, sourceCaption);
        }
        this.encodeList(context, pickList, clientId + "_source", "ui-widget-content ui-picklist-list ui-picklist-source", model.getSource(), hasSourceCaption);
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeButton(context, pickList, pickList.getAddLabel(), "ui-picklist-button ui-picklist-button-add");
        this.encodeButton(context, pickList, pickList.getAddAllLabel(), "ui-picklist-button ui-picklist-button-add-all");
        this.encodeButton(context, pickList, pickList.getRemoveLabel(), "ui-picklist-button ui-picklist-button-remove");
        this.encodeButton(context, pickList, pickList.getRemoveAllLabel(), "ui-picklist-button ui-picklist-button-remove-all");
        writer.endElement("td");
        writer.startElement("td", null);
        UIComponent targetCaption = pickList.getFacet("targetCaption");
        boolean bl2 = hasTargetCaption = targetCaption != null;
        if (hasTargetCaption) {
            this.encodeCaption(context, targetCaption);
        }
        this.encodeList(context, pickList, clientId + "_target", "ui-widget-content ui-picklist-list ui-picklist-target", model.getTarget(), hasTargetCaption);
        writer.endElement("td");
        if (pickList.isShowTargetControls()) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-picklist-target-controls", null);
            this.encodeButton(context, pickList, pickList.getMoveUpLabel(), "ui-picklist-button ui-picklist-button-move-up");
            this.encodeButton(context, pickList, pickList.getMoveTopLabel(), "ui-picklist-button ui-picklist-button-move-top");
            this.encodeButton(context, pickList, pickList.getMoveDownLabel(), "ui-picklist-button ui-picklist-button-move-down");
            this.encodeButton(context, pickList, pickList.getMoveBottomLabel(), "ui-picklist-button ui-picklist-button-move-bottom");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeScript(FacesContext facesContext, PickList pickList) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = pickList.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(pickList.resolveWidgetVar() + " = new PrimeFaces.widget.PickList('" + clientId + "', {");
        writer.write("pojo:" + (pickList.getConverter() != null));
        writer.write(",effect:'" + pickList.getEffect() + "'");
        writer.write(",effectSpeed:'" + pickList.getEffectSpeed() + "'");
        writer.write(",iconOnly:" + pickList.isIconOnly());
        if (pickList.isShowSourceControls()) {
            writer.write(",showSourceControls:true");
        }
        if (pickList.isShowTargetControls()) {
            writer.write(",showTargetControls:true");
        }
        if (pickList.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (pickList.getOnTransfer() != null) {
            writer.write(",onTransfer:function(e) {" + pickList.getOnTransfer() + ";}");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeCaption(FacesContext context, UIComponent caption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-caption ui-widget-header ui-corner-tl ui-corner-tr", null);
        caption.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeButton(FacesContext facesContext, PickList pickList, String label, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write(label);
        writer.endElement("button");
    }

    protected void encodeList(FacesContext context, PickList pickList, String listId, String styleClass, List model, boolean hasCaption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        styleClass = styleClass + (hasCaption ? " ui-corner-bl ui-corner-br" : " ui-corner-all");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        String values = this.encodeOptions(context, pickList, model);
        writer.endElement("ul");
        this.encodeListStateHolder(context, listId, values);
    }

    protected String encodeOptions(FacesContext context, PickList pickList, List model) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = pickList.getVar();
        Converter converter = pickList.getConverter();
        StringBuilder state = new StringBuilder();
        Iterator it = model.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            context.getExternalContext().getRequestMap().put(var, item);
            String value = converter != null ? converter.getAsString(context, (UIComponent)pickList, pickList.getItemValue()) : (String)pickList.getItemValue();
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-state-default ui-picklist-item ui-corner-all", null);
            writer.write(pickList.getItemLabel());
            writer.endElement("li");
            state.append(value);
            if (!it.hasNext()) continue;
            state.append(",");
        }
        context.getExternalContext().getRequestMap().remove(var);
        return state.toString();
    }

    protected void encodeListStateHolder(FacesContext context, String clientId, String values) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("value", (Object)values, null);
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        PickList pickList = (PickList)component;
        String[] value = (String[])submittedValue;
        String[] sourceList = value[0].split(",");
        String[] targetList = value[1].split(",");
        DualListModel model = new DualListModel();
        this.doConvertValue(facesContext, pickList, sourceList, model.getSource());
        this.doConvertValue(facesContext, pickList, targetList, model.getTarget());
        return model;
    }

    protected void doConvertValue(FacesContext facesContext, PickList pickList, String[] values, List model) {
        Converter converter = pickList.getConverter();
        for (String value : values) {
            String convertedValue;
            if (this.isValueBlank(value)) continue;
            String val = value.trim();
            String string = convertedValue = converter != null ? converter.getAsObject(facesContext, (UIComponent)pickList, val) : val;
            if (convertedValue == null) continue;
            model.add(convertedValue);
        }
    }
}

