/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.effect;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.effect.Effect;
import org.primefaces.component.effect.EffectBuilder;
import org.primefaces.renderkit.CoreRenderer;

public class EffectRenderer
extends CoreRenderer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Effect effect = (Effect)component;
        String parentClientId = effect.getParent().getClientId(facesContext);
        String effectedComponentClientId = null;
        if (effect.getFor() != null) {
            UIComponent target = effect.findComponent(effect.getFor());
            if (target == null) throw new FacesException("Cannot find component \"" + effect.getFor() + "\" in view.");
            effectedComponentClientId = target.getClientId(facesContext);
        } else {
            effectedComponentClientId = parentClientId;
        }
        String animation = this.getEffectBuilder(effect, effectedComponentClientId).build();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        if (effect.getEvent().equals("load")) {
            writer.write(animation);
        } else {
            writer.write("jQuery(PrimeFaces.escapeClientId('" + parentClientId + "'))");
            writer.write(".bind('" + effect.getEvent() + "', function() {" + animation + "});");
        }
        writer.write("});");
        writer.endElement("script");
    }

    private EffectBuilder getEffectBuilder(Effect effect, String effectedComponentClientId) {
        EffectBuilder effectBuilder = new EffectBuilder(effect.getType(), effectedComponentClientId);
        for (UIComponent child : effect.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            effectBuilder.withOption(param.getName(), (String)param.getValue());
        }
        effectBuilder.atSpeed(effect.getSpeed());
        return effectBuilder;
    }
}

