/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public abstract class BaseMenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.shouldBuildFromModel()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected abstract void encodeMarkup(FacesContext var1, AbstractMenu var2) throws IOException;

    protected abstract void encodeScript(FacesContext var1, AbstractMenu var2) throws IOException;

    protected void encodeMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        String clientId = menuItem.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuItem.getIcon();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuItem);
        } else {
            writer.startElement("a", null);
            if (menuItem.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(context, menuItem.getUrl()), null);
                if (menuItem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                }
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"javascript:void(0)", null);
                UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Menubar must be inside a form element");
                }
                String formClientId = form.getClientId(context);
                String command = menuItem.isAjax() ? this.buildAjaxRequest(context, menuItem, formClientId, clientId) : this.buildNonAjaxRequest(context, (UIComponent)menuItem, formClientId, clientId);
                command = menuItem.getOnclick() == null ? command : menuItem.getOnclick() + ";" + command;
                writer.writeAttribute("onclick", (Object)command, null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
                writer.endElement("span");
            }
            if (menuItem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"wijmo-wijmenu-text", null);
                writer.write((String)menuItem.getValue());
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

