/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;

public class MenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        String widgetVar = menu.resolveWidgetVar();
        String position = menu.getPosition();
        String type = menu.getType();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.Menu('" + clientId + "',{");
        writer.write("position:'" + menu.getPosition() + "'");
        writer.write(",zindex:" + menu.getZindex());
        writer.write(",animated:'" + menu.getEffect() + "'");
        if (type.equalsIgnoreCase("sliding")) {
            writer.write(",mode:'sliding'");
            writer.write(",backLinkText:'" + menu.getBackLabel() + "'");
            writer.write(",maxHeight:" + menu.getMaxHeight());
        }
        if (menu.getEffectDuration() != 400) {
            writer.write(",showDuration:" + menu.getEffectDuration());
            writer.write(",hideDuration:" + menu.getEffectDuration());
        }
        if (position.equalsIgnoreCase("dynamic")) {
            writer.write(",my:'" + menu.getMy() + "'");
            writer.write(",at:'" + menu.getAt() + "'");
            UIComponent trigger = menu.findComponent(menu.getTrigger());
            if (trigger != null) {
                writer.write(",trigger:'" + trigger.getClientId(context) + "'");
            } else {
                writer.write(",trigger:'" + menu.getTrigger() + "'");
            }
        }
        if (menu.getStyleClass() != null) {
            writer.write(",styleClass:'" + menu.getStyleClass() + "'");
        }
        if (menu.getStyle() != null) {
            writer.write(",style:'" + menu.getStyle() + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        boolean tiered = menu.isTiered() || !menu.getType().equalsIgnoreCase("plain");
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        if (tiered) {
            this.encodeTieredMenuContent(context, (UIComponent)menu);
        } else {
            this.encodePlainMenuContent(context, (UIComponent)menu);
        }
        writer.endElement("ul");
        writer.endElement("span");
    }

    protected void encodeTieredMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", null);
            if (child instanceof MenuItem) {
                this.encodeMenuItem(context, (MenuItem)child);
            } else if (child instanceof Submenu) {
                this.encodeTieredSubmenu(context, (Submenu)child);
            }
            writer.endElement("li");
        }
    }

    protected void encodeTieredSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"wijmo-wijmenu-text", null);
            writer.write(submenu.getLabel());
            writer.endElement("span");
        }
        writer.endElement("a");
        if (submenu.getChildCount() > 0) {
            writer.startElement("ul", null);
            this.encodeTieredMenuContent(context, (UIComponent)submenu);
            writer.endElement("ul");
        }
    }

    protected void encodePlainMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Submenu)) continue;
            this.encodePlainSubmenu(context, (Submenu)child);
        }
    }

    protected void encodePlainSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        writer.startElement("li", null);
        writer.startElement("h3", null);
        if (label != null) {
            writer.write(label);
        }
        writer.endElement("h3");
        writer.endElement("li");
        this.encodePlainMenuContent(context, (UIComponent)submenu);
    }
}

