/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.progressbar;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.progressbar.ProgressBar;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class ProgressBarRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        ProgressBar progressBar = (ProgressBar)component;
        String clientId = progressBar.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            if (params.containsKey(clientId + "_cancel")) {
                progressBar.getValueExpression("value").setValue(facesContext.getELContext(), (Object)0);
                if (progressBar.getCancelListener() != null) {
                    progressBar.getCancelListener().invoke(facesContext.getELContext(), null);
                }
            } else if (params.containsKey(clientId + "_complete")) {
                if (progressBar.getCompleteListener() != null) {
                    progressBar.getCompleteListener().invoke(facesContext.getELContext(), null);
                }
            } else {
                RequestContext.getCurrentInstance().addCallbackParam(progressBar.getClientId(facesContext) + "_value", progressBar.getValue());
            }
            FacesContext.getCurrentInstance().renderResponse();
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ProgressBar progressBar = (ProgressBar)component;
        this.encodeMarkup(facesContext, progressBar);
        this.encodeScript(facesContext, progressBar);
    }

    protected void encodeMarkup(FacesContext facesContext, ProgressBar progressBar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)progressBar);
        writer.writeAttribute("id", (Object)progressBar.getClientId(facesContext), "id");
        if (progressBar.getStyle() != null) {
            writer.writeAttribute("style", (Object)progressBar.getStyle(), "style");
        }
        if (progressBar.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)progressBar.getStyleClass(), "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, ProgressBar progressBar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = progressBar.getClientId(facesContext);
        writer.startElement("script", (UIComponent)progressBar);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(progressBar.resolveWidgetVar() + " = new PrimeFaces.widget.ProgressBar('" + clientId + "', {");
        writer.write("value:" + progressBar.getValue());
        if (progressBar.isAjax()) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)progressBar);
            if (form == null) {
                throw new FacesException("ProgressBar \"" + clientId + "\" must be enclosed with a form in ajax mode.");
            }
            writer.write(",ajax:true");
            writer.write(",interval:" + progressBar.getInterval());
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
            if (progressBar.getOnCompleteUpdate() != null) {
                writer.write(",onCompleteUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)progressBar, progressBar.getOnCompleteUpdate()) + "'");
            }
            if (progressBar.getOnCancelUpdate() != null) {
                writer.write(",onCancelUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)progressBar, progressBar.getOnCancelUpdate()) + "'");
            }
            if (progressBar.getOncomplete() != null) {
                writer.write(",oncomplete:function(xhr, status, args) {" + progressBar.getOncomplete() + "}");
            }
        } else {
            writer.write(",ajax:false");
        }
        if (progressBar.isDisabled()) {
            writer.write(",disabled:true");
        }
        writer.write("});");
        writer.endElement("script");
    }
}

