/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.model.TreeNode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TreeTableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TreeTable treeTable = (TreeTable)component;
        this.encodeMarkup(facesContext, treeTable);
        this.encodeScript(facesContext, treeTable);
    }

    protected void encodeScript(FacesContext facesContext, TreeTable treeTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = treeTable.getClientId(facesContext);
        String initialState = treeTable.isExpanded() ? "expanded" : "collapsed";
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(treeTable.resolveWidgetVar() + " = new PrimeFaces.widget.TreeTable('" + clientId + "', {");
        writer.write("initialState:'" + initialState + "'");
        if (treeTable.isReadOnly()) {
            writer.write(",expandable:false");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, TreeTable treeTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = treeTable.getClientId(facesContext);
        String styleClass = treeTable.getStyleClass() == null ? "ui-treetable ui-widget ui-widget-content" : "ui-treetable ui-widget ui-widget-content " + treeTable.getStyleClass();
        writer.startElement("table", (UIComponent)treeTable);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (treeTable.getStyle() != null) {
            writer.writeAttribute("style", (Object)treeTable.getStyle(), null);
        }
        this.encodeHeaders(facesContext, treeTable);
        this.encodeRows(facesContext, treeTable);
        writer.endElement("table");
    }

    protected void encodeHeaders(FacesContext facesContext, TreeTable treeTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("thead", null);
        writer.startElement("tr", null);
        for (UIComponent kid : treeTable.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Column)) continue;
            Column column = (Column)kid;
            String columnStyleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
            writer.startElement("th", null);
            writer.writeAttribute("class", (Object)columnStyleClass, null);
            UIComponent header = column.getFacet("header");
            if (header != null) {
                if (ComponentUtils.isLiteralText(header)) {
                    writer.write(header.toString());
                } else {
                    header.encodeAll(facesContext);
                }
            }
            writer.endElement("th");
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    protected void encodeRows(FacesContext facesContext, TreeTable treeTable) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        TreeNode root = (TreeNode)treeTable.getValue();
        String clientId = treeTable.getEscapedClientId(facesContext);
        int rowKey = 0;
        writer.startElement("tbody", null);
        writer.writeAttribute("class", (Object)"ui-treetable-data", null);
        if (root != null) {
            Iterator<TreeNode> iterator = root.getChildren().iterator();
            while (iterator.hasNext()) {
                this.encodeTreeNode(facesContext, treeTable, iterator.next(), clientId, String.valueOf(rowKey), null);
                ++rowKey;
            }
        }
        treeTable.setRowIndex(-1);
        writer.endElement("tbody");
    }

    protected void encodeTreeNode(FacesContext facesContext, TreeTable treeTable, TreeNode treeNode, String clientId, String rowKey, String parentRowKey) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        int rowIndex = 0;
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(clientId + "_" + rowKey), null);
        String styleClass = "ui-widget-content";
        if (parentRowKey != null) {
            styleClass = styleClass + " child-of-" + clientId + "_" + parentRowKey;
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        treeTable.setRowIndex(treeTable.getRowIndex() + 1);
        for (UIComponent kid : treeTable.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Column)) continue;
            Column column = (Column)kid;
            writer.startElement("td", null);
            if (column.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)column.getStyleClass(), null);
            }
            column.encodeAll(facesContext);
            writer.endElement("td");
        }
        writer.endElement("tr");
        Iterator<Object> iterator = treeNode.getChildren().iterator();
        while (iterator.hasNext()) {
            String nodeRowKey = rowKey + "_" + rowIndex;
            this.encodeTreeNode(facesContext, treeTable, (TreeNode)iterator.next(), clientId, nodeRowKey, rowKey);
            ++rowIndex;
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

