/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.util.ComponentUtils;

public class CoreRenderer
extends Renderer {
    protected void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            this.renderChild(facesContext, child);
        }
    }

    protected void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    protected String getActionURL(FacesContext facesContext) {
        String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, facesContext.getViewRoot().getViewId());
        return facesContext.getExternalContext().encodeActionURL(actionURL);
    }

    protected String getResourceURL(FacesContext facesContext, String value) {
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value);
        return facesContext.getExternalContext().encodeResourceURL(url);
    }

    protected String getResourceRequestPath(FacesContext facesContext, String resourceName) {
        Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, "primefaces");
        return resource.getRequestPath();
    }

    public boolean isPostback(FacesContext facesContext) {
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String var, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String event : attrs) {
            String eventHandler = (String)component.getAttributes().get(event);
            if (eventHandler == null) continue;
            writer.write(var + ".addListener(\"" + event.substring(2, event.length()) + "\", function(e){" + eventHandler + ";});\n");
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value = component.getAttributes().get(attribute);
            if (!this.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    protected void renderPassThruAttributes(FacesContext facesContext, UIComponent component, String[] attrs, String[] ignoredAttrs) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (String attribute : attrs) {
            Object value;
            if (this.isIgnoredAttribute(attribute, ignoredAttrs) || !this.shouldRenderAttribute(value = component.getAttributes().get(attribute))) continue;
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    private boolean isIgnoredAttribute(String attribute, String[] ignoredAttrs) {
        for (String ignoredAttribute : ignoredAttrs) {
            if (!attribute.equals(ignoredAttribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldRenderAttribute(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Integer) {
                return number.intValue() != Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return number.doubleValue() != Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return number.longValue() != Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return number.byteValue() != -128;
            }
            if (value instanceof Float) {
                return number.floatValue() != Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return number.shortValue() != Short.MIN_VALUE;
            }
        }
        return true;
    }

    protected boolean isPostBack() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getRenderKit().getResponseStateManager().isPostback(facesContext);
    }

    public String getEscapedClientId(String clientId) {
        return clientId.replaceAll(":", "\\\\\\\\:");
    }

    public boolean isValueEmpty(String value) {
        return value == null || "".equals(value);
    }

    public boolean isValueBlank(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().equals("");
    }

    protected String buildAjaxRequest(FacesContext facesContext, AjaxSource source, String formId, String decodeParam) {
        UIComponent component = (UIComponent)source;
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ajax.AjaxRequest(");
        req.append("'").append(this.getActionURL(facesContext)).append("'");
        req.append(",{formId:'").append(formId).append("'");
        req.append(",async:").append(source.isAsync());
        req.append(",global:").append(source.isGlobal());
        req.append(",source:'").append(decodeParam).append("'");
        String process = source.getProcess() != null ? ComponentUtils.findClientIds(facesContext, component, source.getProcess()) : "@all";
        req.append(",process:'").append(process).append("'");
        if (source.getUpdate() != null) {
            req.append(",update:'").append(ComponentUtils.findClientIds(facesContext, component, source.getUpdate())).append("'");
        }
        if (source.getOnstart() != null) {
            req.append(",onstart:function(){").append(source.getOnstart()).append(";}");
        }
        if (source.getOnerror() != null) {
            req.append(",onerror:function(xhr, status, error){").append(source.getOnerror()).append(";}");
        }
        if (source.getOnsuccess() != null) {
            req.append(",onsuccess:function(data, status, xhr, args){").append(source.getOnsuccess()).append(";}");
        }
        if (source.getOncomplete() != null) {
            req.append(",oncomplete:function(xhr, status, args){").append(source.getOncomplete()).append(";}");
        }
        req.append("}");
        boolean firstParam = true;
        boolean hasParam = false;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            hasParam = true;
            if (firstParam) {
                firstParam = false;
                req.append(",{");
            } else {
                req.append(",");
            }
            req.append("'").append(parameter.getName()).append("':'").append(parameter.getValue()).append("'");
        }
        if (hasParam) {
            req.append("}");
        }
        req.append(");");
        return req.toString();
    }

    protected String buildNonAjaxRequest(FacesContext facesContext, UIComponent component, String formId, String decodeParam) {
        StringBuilder request = new StringBuilder();
        request.append("PrimeFaces").append(this.addSubmitParam(formId, decodeParam, decodeParam));
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            request.append(this.addSubmitParam(formId, param.getName(), String.valueOf(param.getValue())));
        }
        request.append(".submit('").append(formId).append("');");
        return request.toString();
    }

    protected String addSubmitParam(String parent, String name, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(".addSubmitParam('").append(parent).append("','").append(name).append("','").append(value).append("')");
        return builder.toString();
    }

    protected String escapeText(String value) {
        return value == null ? "" : value.replaceAll("'", "\\\\'");
    }

    protected void encodeClientBehaviors(FacesContext context, ClientBehaviorHolder component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map behaviorEvents = component.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            List params = Collections.emptyList();
            writer.write(",behaviors:{");
            Iterator eventIterator = behaviorEvents.keySet().iterator();
            while (eventIterator.hasNext()) {
                String event;
                String domEvent = event = (String)eventIterator.next();
                if (event.equalsIgnoreCase("valueChange")) {
                    domEvent = "change";
                } else if (event.equalsIgnoreCase("action")) {
                    domEvent = "click";
                }
                writer.write(domEvent + ":");
                writer.write("[");
                Iterator behaviorIter = ((List)behaviorEvents.get(event)).iterator();
                while (behaviorIter.hasNext()) {
                    ClientBehavior behavior = (ClientBehavior)behaviorIter.next();
                    ClientBehaviorContext cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)((UIComponent)component), (String)event, null, params);
                    writer.write("function(event){" + behavior.getScript(cbc) + ";}");
                    if (!behaviorIter.hasNext()) continue;
                    writer.write(",");
                }
                writer.write("]");
                if (!eventIterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("}");
        }
    }
}

