/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.primefaces.component.chart.UIChart;
import org.primefaces.event.ItemSelectEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class BaseChartRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(BaseChartRenderer.class.getName());

    public void decode(FacesContext fc, UIComponent component) {
        String clientId = component.getClientId(fc);
        Map params = fc.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId + "_ajaxItemSelect")) {
            int seriesIndex = Integer.parseInt((String)params.get(clientId + "_seriesIndex"));
            int itemIndex = Integer.parseInt((String)params.get(clientId + "_itemIndex"));
            component.queueEvent((FacesEvent)new ItemSelectEvent(component, itemIndex, seriesIndex));
        }
    }

    protected void encodeResources(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("YAHOO.widget.Chart.SWFURL = '" + this.getResourceRequestPath(facesContext, "yui/charts/assets/charts.swf") + "'");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, UIChart chart) throws IOException {
        if (!chart.hasModel()) {
            logger.log(Level.INFO, "Chart \"{0}\" has no ChartModel, declarative way of creating charts is deprecated, use a ChartModel instead.", chart.getClientId(context));
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)chart.getClientId(context), null);
        writer.writeAttribute("style", (Object)("width:" + chart.getWidth() + ";height:" + chart.getHeight()), null);
        if (chart.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)chart.getStyleClass(), "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeCommonConfig(FacesContext context, UIChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("expressInstall:'" + this.getResourceRequestPath(context, "yui/assets/expressinstall.swf") + "'");
        if (chart.getWmode() != null) {
            writer.write(",wmode:'" + chart.getWmode() + "'");
        }
        if (chart.getStyle() != null) {
            writer.write(",style:" + chart.getStyle() + "");
        }
        if (chart.getDataTipFunction() != null) {
            writer.write(",dataTipFunction:" + chart.getDataTipFunction());
        }
        if (chart.isLive() || chart.getItemSelectListener() != null) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)chart);
            if (form == null) {
                throw new FacesException("Chart: '" + chart.getClientId(context) + "' must be inside a form element");
            }
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",formId:'" + form.getClientId(context) + "'");
        }
        if (chart.isLive()) {
            writer.write(",live:true");
            writer.write(",refreshInterval:" + chart.getRefreshInterval());
        }
        if (chart.getItemSelectListener() != null) {
            writer.write(",ajaxItemSelect: true");
            if (chart.getUpdate() != null) {
                writer.write(",update:'" + ComponentUtils.findClientIds(context, (UIComponent)chart, chart.getUpdate()) + "'");
            }
            if (chart.getOncomplete() != null) {
                writer.write(",oncomplete: function() {" + chart.getOncomplete() + ";}");
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

