/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandlink;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class CommandLinkRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        CommandLink link = (CommandLink)component;
        if (link.isDisabled()) {
            return;
        }
        String param = component.getClientId();
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        CommandLink link = (CommandLink)component;
        String clientId = link.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)link);
        if (form == null) {
            throw new FacesException("Commandlink \"" + clientId + "\" must be inside a form component");
        }
        if (!link.isDisabled()) {
            writer.startElement("a", (UIComponent)link);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("href", (Object)"javascript:void(0);", null);
            if (link.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)link.getStyleClass(), null);
            }
            String formClientId = form.getClientId(facesContext);
            String request = link.isAjax() ? this.buildAjaxRequest(facesContext, link, formClientId, clientId) : this.buildNonAjaxRequest(facesContext, (UIComponent)link, formClientId, clientId);
            String onclick = link.getOnclick() != null ? link.getOnclick() + ";" + request : request;
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
            this.renderPassThruAttributes(facesContext, (UIComponent)link, HTML.LINK_ATTRS, HTML.CLICK_EVENT);
            if (link.getValue() != null) {
                writer.write(link.getValue().toString());
            } else {
                this.renderChildren(facesContext, (UIComponent)link);
            }
            writer.endElement("a");
        } else {
            writer.startElement("span", (UIComponent)link);
            writer.writeAttribute("id", (Object)clientId, "id");
            if (link.getValue() != null) {
                writer.write(link.getValue().toString());
            } else {
                this.renderChildren(facesContext, (UIComponent)link);
            }
            writer.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

