/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.confirmdialog;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.confirmdialog.ConfirmDialog;
import org.primefaces.renderkit.CoreRenderer;

public class ConfirmDialogRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ConfirmDialog dialog = (ConfirmDialog)component;
        this.encodeMarkup(context, dialog);
        this.encodeScript(context, dialog);
    }

    protected void encodeMarkup(FacesContext context, ConfirmDialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        String messageText = dialog.getMessage();
        UIComponent messageFacet = dialog.getFacet("message");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (dialog.getHeader() != null) {
            writer.writeAttribute("title", (Object)dialog.getHeader(), null);
        }
        writer.startElement("p", null);
        writer.startElement("span", null);
        writer.writeAttribute("style", (Object)"float: left; margin: 0pt 7px 20px 0pt;", null);
        writer.writeAttribute("class", (Object)("ui-icon ui-icon-" + dialog.getSeverity()), null);
        writer.endElement("span");
        if (messageFacet != null) {
            messageFacet.encodeAll(context);
        } else if (messageText != null) {
            writer.write(dialog.getMessage());
        }
        writer.endElement("p");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_buttons"), null);
        this.renderChildren(context, (UIComponent)dialog);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ConfirmDialog dialog) throws IOException {
        String position;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId();
        writer.startElement("script", (UIComponent)dialog);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(dialog.resolveWidgetVar() + " = new PrimeFaces.widget.ConfirmDialog('" + clientId + "', {");
        writer.write("minHeight:0");
        if (dialog.getStyleClass() != null) {
            writer.write(",dialogClass:'" + dialog.getStyleClass() + "'");
        }
        if (dialog.getWidth() != 300) {
            writer.write(",width:" + dialog.getWidth());
        }
        if (dialog.getHeight() != Integer.MIN_VALUE) {
            writer.write(",height:" + dialog.getHeight());
        }
        if (!dialog.isDraggable()) {
            writer.write(",draggable:false");
        }
        if (dialog.isModal()) {
            writer.write(",modal: true");
        }
        if (dialog.getZindex() != 1000) {
            writer.write(",zIndex:" + dialog.getZindex());
        }
        if (dialog.getShowEffect() != null) {
            writer.write(",show:'" + dialog.getShowEffect() + "'");
        }
        if (dialog.getHideEffect() != null) {
            writer.write(",hide:'" + dialog.getHideEffect() + "'");
        }
        if (!dialog.isCloseOnEscape()) {
            writer.write(",closeOnEscape:false");
        }
        if (!dialog.isClosable()) {
            writer.write(",closable:false");
        }
        if (dialog.isAppendToBody()) {
            writer.write(",appendToBody:true");
        }
        if ((position = dialog.getPosition()) != null) {
            if (position.contains(",")) {
                writer.write(",position:[" + position + "]");
            } else {
                writer.write(",position:'" + position + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

