/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datagrid.DataGrid;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DataGridRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Map params = context.getExternalContext().getRequestParameterMap();
        DataGrid grid = (DataGrid)component;
        String clientId = grid.getClientId();
        if (grid.isPagingRequest(context)) {
            grid.setFirst(Integer.valueOf((String)params.get(clientId + "_first")));
            grid.setRows(Integer.valueOf((String)params.get(clientId + "_rows")));
            grid.setPage(Integer.valueOf((String)params.get(clientId + "_page")));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataGrid grid = (DataGrid)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (grid.isPagingRequest(context)) {
            this.encodeTable(context, grid);
        } else {
            this.encodeMarkup(context, grid);
            this.encodeScript(context, grid);
        }
    }

    protected void encodeMarkup(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId();
        boolean hasPaginator = grid.isPaginator();
        String paginatorPosition = grid.getPaginatorPosition();
        String styleClass = grid.getStyleClass() == null ? "ui-datagrid ui-widget" : "ui-datagrid ui-widget " + grid.getStyleClass();
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorContainer(context, clientId + "_paginatorTop");
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-datagrid-content", null);
        this.encodeTable(context, grid);
        writer.endElement("div");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorContainer(context, clientId + "_paginatorBottom");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId();
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)grid);
        if (form == null) {
            throw new FacesException("DataGrid : \"" + clientId + "\" must be inside a form element");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(grid.resolveWidgetVar() + " = new PrimeFaces.widget.DataGrid('" + clientId + "',{");
        writer.write("url:'" + this.getActionURL(context) + "'");
        writer.write(",formId:'" + form.getClientId() + "'");
        if (grid.isPaginator()) {
            writer.write(",paginator:new YAHOO.widget.Paginator({");
            writer.write("rowsPerPage:" + grid.getRows());
            writer.write(",totalRecords:" + grid.getRowCount());
            writer.write(",initialPage:" + grid.getPage());
            if (grid.getPageLinks() != 10) {
                writer.write(",pageLinks:" + grid.getPageLinks());
            }
            if (grid.getPaginatorTemplate() != null) {
                writer.write(",template:'" + grid.getPaginatorTemplate() + "'");
            }
            if (grid.getRowsPerPageTemplate() != null) {
                writer.write(",rowsPerPageOptions : [" + grid.getRowsPerPageTemplate() + "]");
            }
            if (grid.getCurrentPageReportTemplate() != null) {
                writer.write(",pageReportTemplate:'" + grid.getCurrentPageReportTemplate() + "'");
            }
            if (!grid.isPaginatorAlwaysVisible()) {
                writer.write(",alwaysVisible:false");
            }
            String paginatorPosition = grid.getPaginatorPosition();
            String paginatorContainer = null;
            if (paginatorPosition.equals("both")) {
                paginatorContainer = clientId + "_paginatorTop','" + clientId + "_paginatorBottom";
            } else if (paginatorPosition.equals("top")) {
                paginatorContainer = clientId + "_paginatorTop";
            } else if (paginatorPosition.equals("bottom")) {
                paginatorContainer = clientId + "_paginatorBottom";
            }
            writer.write(",containers:['" + paginatorContainer + "']");
            writer.write("})");
            if (grid.isEffect()) {
                writer.write(",effect:true");
                writer.write(",effectSpeed:'" + grid.getEffectSpeed() + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeTable(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        int itemsToRender = rows != 0 ? rows : grid.getRowCount();
        int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("class", (Object)"ui-datagrid-data", null);
        writer.startElement("tbody", null);
        for (int i = 0; i < numberOfRowsToRender; ++i) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-datagrid-row", null);
            for (int j = 0; j < columns; ++j) {
                grid.setRowIndex(rowIndex);
                if (!grid.isRowAvailable()) break;
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)"ui-datagrid-column", null);
                if (grid.isRowAvailable()) {
                    this.renderChildren(context, (UIComponent)grid);
                    ++rowIndex;
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        grid.setRowIndex(-1);
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodePaginatorContainer(FacesContext context, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("class", (Object)"ui-paginator ui-widget-header ui-corner-all", null);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

