/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.row.Row;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.model.LazyDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/ui/jquery-ui.css"), @ResourceDependency(library="primefaces", name="paginator/paginator.css"), @ResourceDependency(library="primefaces", name="datatable/datatable.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="yui/utilities/utilities.js"), @ResourceDependency(library="primefaces", name="paginator/paginator.js"), @ResourceDependency(library="primefaces", name="core/core.js"), @ResourceDependency(library="primefaces", name="datatable/datatable.js")})
public class DataTable
extends UIData
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DataTableRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.component.";
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String DATA_CLASS = "ui-datatable-data";
    public static final String EMPTY_DATA_CLASS = "ui-datatable-data-empty";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header ui-corner-tl ui-corner-tr";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header ui-corner-bl ui-corner-br";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-datatable-scrollable-header";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-datatable-scrollable-footer";
    public List<Column> columns;
    private Boolean pageRequest = null;
    private Boolean sortRequest = null;
    private Boolean filterRequest = null;
    private Boolean clearFiltersRequest = null;
    private Map<String, Column> filterMap;
    private boolean emptySelected = false;
    private List<Integer> selectedRowIndexes = new ArrayList<Integer>();

    public DataTable() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
        this.handleAttribute("widgetVar", _widgetVar);
    }

    public boolean isPaginator() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginator), (Object)false);
    }

    public void setPaginator(boolean _paginator) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginator), (Object)_paginator);
        this.handleAttribute("paginator", _paginator);
    }

    public String getPaginatorTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorTemplate), null);
    }

    public void setPaginatorTemplate(String _paginatorTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorTemplate), (Object)_paginatorTemplate);
        this.handleAttribute("paginatorTemplate", _paginatorTemplate);
    }

    public String getRowsPerPageTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowsPerPageTemplate), null);
    }

    public void setRowsPerPageTemplate(String _rowsPerPageTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowsPerPageTemplate), (Object)_rowsPerPageTemplate);
        this.handleAttribute("rowsPerPageTemplate", _rowsPerPageTemplate);
    }

    public String getCurrentPageReportTemplate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.currentPageReportTemplate), null);
    }

    public void setCurrentPageReportTemplate(String _currentPageReportTemplate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.currentPageReportTemplate), (Object)_currentPageReportTemplate);
        this.handleAttribute("currentPageReportTemplate", _currentPageReportTemplate);
    }

    public int getPageLinks() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.pageLinks), (Object)10);
    }

    public void setPageLinks(int _pageLinks) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.pageLinks), (Object)_pageLinks);
        this.handleAttribute("pageLinks", _pageLinks);
    }

    public String getPaginatorPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorPosition), (Object)"both");
    }

    public void setPaginatorPosition(String _paginatorPosition) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorPosition), (Object)_paginatorPosition);
        this.handleAttribute("paginatorPosition", _paginatorPosition);
    }

    public boolean isPaginatorAlwaysVisible() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.paginatorAlwaysVisible), (Object)true);
    }

    public void setPaginatorAlwaysVisible(boolean _paginatorAlwaysVisible) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.paginatorAlwaysVisible), (Object)_paginatorAlwaysVisible);
        this.handleAttribute("paginatorAlwaysVisible", _paginatorAlwaysVisible);
    }

    public int getPage() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.page), (Object)1);
    }

    public void setPage(int _page) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.page), (Object)_page);
        this.handleAttribute("page", _page);
    }

    public boolean isScrollable() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.scrollable), (Object)false);
    }

    public void setScrollable(boolean _scrollable) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.scrollable), (Object)_scrollable);
        this.handleAttribute("scrollable", _scrollable);
    }

    public int getHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height), (Object)Integer.MIN_VALUE);
    }

    public void setHeight(int _height) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)_height);
        this.handleAttribute("height", _height);
    }

    public String getSelectionMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selectionMode), null);
    }

    public void setSelectionMode(String _selectionMode) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selectionMode), (Object)_selectionMode);
        this.handleAttribute("selectionMode", _selectionMode);
    }

    public Object getSelection() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.selection), null);
    }

    public void setSelection(Object _selection) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.selection), _selection);
        this.handleAttribute("selection", _selection);
    }

    public boolean isDynamic() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dynamic), (Object)false);
    }

    public void setDynamic(boolean _dynamic) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dynamic), (Object)_dynamic);
        this.handleAttribute("dynamic", _dynamic);
    }

    public boolean isLazy() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.lazy), (Object)false);
    }

    public void setLazy(boolean _lazy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lazy), (Object)_lazy);
        this.handleAttribute("lazy", _lazy);
    }

    public String getRowIndexVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexVar), null);
    }

    public void setRowIndexVar(String _rowIndexVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexVar), (Object)_rowIndexVar);
        this.handleAttribute("rowIndexVar", _rowIndexVar);
    }

    public String getEmptyMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.emptyMessage), (Object)"No records found.");
    }

    public void setEmptyMessage(String _emptyMessage) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.emptyMessage), (Object)_emptyMessage);
        this.handleAttribute("emptyMessage", _emptyMessage);
    }

    public String getUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.update), null);
    }

    public void setUpdate(String _update) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.update), (Object)_update);
        this.handleAttribute("update", _update);
    }

    public String getOnRowSelectUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onRowSelectUpdate), null);
    }

    public void setOnRowSelectUpdate(String _onRowSelectUpdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onRowSelectUpdate), (Object)_onRowSelectUpdate);
        this.handleAttribute("onRowSelectUpdate", _onRowSelectUpdate);
    }

    public MethodExpression getRowSelectListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowSelectListener), null);
    }

    public void setRowSelectListener(MethodExpression _rowSelectListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowSelectListener), (Object)_rowSelectListener);
        this.handleAttribute("rowSelectListener", _rowSelectListener);
    }

    public MethodExpression getRowUnselectListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowUnselectListener), null);
    }

    public void setRowUnselectListener(MethodExpression _rowUnselectListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowUnselectListener), (Object)_rowUnselectListener);
        this.handleAttribute("rowUnselectListener", _rowUnselectListener);
    }

    public String getOnRowUnselectUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onRowUnselectUpdate), null);
    }

    public void setOnRowUnselectUpdate(String _onRowUnselectUpdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onRowUnselectUpdate), (Object)_onRowUnselectUpdate);
        this.handleAttribute("onRowUnselectUpdate", _onRowUnselectUpdate);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
        this.handleAttribute("style", _style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
        this.handleAttribute("styleClass", _styleClass);
    }

    public String getOnselectStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onselectStart), null);
    }

    public void setOnselectStart(String _onselectStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onselectStart), (Object)_onselectStart);
        this.handleAttribute("onselectStart", _onselectStart);
    }

    public String getOnselectComplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onselectComplete), null);
    }

    public void setOnselectComplete(String _onselectComplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onselectComplete), (Object)_onselectComplete);
        this.handleAttribute("onselectComplete", _onselectComplete);
    }

    public String getOnRowSelectStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onRowSelectStart), null);
    }

    public void setOnRowSelectStart(String _onRowSelectStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onRowSelectStart), (Object)_onRowSelectStart);
        this.handleAttribute("onRowSelectStart", _onRowSelectStart);
    }

    public String getOnRowSelectComplete() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onRowSelectComplete), null);
    }

    public void setOnRowSelectComplete(String _onRowSelectComplete) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onRowSelectComplete), (Object)_onRowSelectComplete);
        this.handleAttribute("onRowSelectComplete", _onRowSelectComplete);
    }

    public boolean isDblClickSelect() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dblClickSelect), (Object)false);
    }

    public void setDblClickSelect(boolean _dblClickSelect) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.dblClickSelect), (Object)_dblClickSelect);
        this.handleAttribute("dblClickSelect", _dblClickSelect);
    }

    public boolean isLiveScroll() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.liveScroll), (Object)false);
    }

    public void setLiveScroll(boolean _liveScroll) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.liveScroll), (Object)_liveScroll);
        this.handleAttribute("liveScroll", _liveScroll);
    }

    public String getRowStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStyleClass), null);
    }

    public void setRowStyleClass(String _rowStyleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStyleClass), (Object)_rowStyleClass);
        this.handleAttribute("rowStyleClass", _rowStyleClass);
    }

    public MethodExpression getRowEditListener() {
        return (MethodExpression)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowEditListener), null);
    }

    public void setRowEditListener(MethodExpression _rowEditListener) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowEditListener), (Object)_rowEditListener);
        this.handleAttribute("rowEditListener", _rowEditListener);
    }

    public String getOnRowEditUpdate() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onRowEditUpdate), null);
    }

    public void setOnRowEditUpdate(String _onRowEditUpdate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onRowEditUpdate), (Object)_onRowEditUpdate);
        this.handleAttribute("onRowEditUpdate", _onRowEditUpdate);
    }

    public String getOnExpandStart() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onExpandStart), null);
    }

    public void setOnExpandStart(String _onExpandStart) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.onExpandStart), (Object)_onExpandStart);
        this.handleAttribute("onExpandStart", _onExpandStart);
    }

    public List<Column> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered() || !(child instanceof Column)) continue;
                this.columns.add((Column)child);
            }
        }
        return this.columns;
    }

    public boolean isPaginationRequest(FacesContext context) {
        if (this.pageRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.pageRequest = params.containsKey(this.getClientId(context) + "_paging");
        }
        return this.pageRequest;
    }

    public boolean isSortRequest(FacesContext context) {
        if (this.sortRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.sortRequest = params.containsKey(this.getClientId(context) + "_sorting");
        }
        return this.sortRequest;
    }

    public boolean isFilterRequest(FacesContext context) {
        if (this.filterRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.filterRequest = params.containsKey(this.getClientId(context) + "_filtering");
        }
        return this.filterRequest;
    }

    public boolean isClearFiltersRequest(FacesContext context) {
        if (this.clearFiltersRequest == null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.clearFiltersRequest = params.containsKey(this.getClientId(context) + "_clearFilters");
        }
        return this.clearFiltersRequest;
    }

    public boolean isGlobalFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_globalFilter");
    }

    public boolean isDataManipulationRequest(FacesContext context) {
        return this.isPaginationRequest(context) || this.isSortRequest(context) || this.isFilterRequest(context);
    }

    public boolean isInstantSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelectedRowIndex");
    }

    public boolean isInstantUnselectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantUnselectedRowIndex");
    }

    public boolean isRowExpansionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowExpansion");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEdit");
    }

    public boolean isScrollingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_scrolling");
    }

    public Map<String, Column> getFilterMap() {
        block5: {
            if (this.filterMap != null) break block5;
            this.filterMap = new HashMap<String, Column>();
            ColumnGroup group = this.getColumnGroup("header");
            if (group != null) {
                for (UIComponent child : group.getChildren()) {
                    Row headerRow = (Row)child;
                    if (!headerRow.isRendered()) continue;
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        Column column = (Column)headerRowChild;
                        if (!column.isRendered() || column.getValueExpression("filterBy") == null) continue;
                        this.filterMap.put(column.getClientId(FacesContext.getCurrentInstance()) + "_filter", column);
                    }
                }
            } else {
                for (Column column : this.getColumns()) {
                    if (column.getValueExpression("filterBy") == null) continue;
                    this.filterMap.put(column.getClientId(FacesContext.getCurrentInstance()) + "_filter", column);
                }
            }
        }
        return this.filterMap;
    }

    public boolean hasFilter() {
        return this.getFilterMap().size() > 0;
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (Column column : this.getColumns()) {
            String selectionMode = column.getSelectionMode();
            if (selectionMode == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        String columnSelectionMode = this.getColumnSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single") || selectionMode.equalsIgnoreCase("singlecell");
        }
        if (columnSelectionMode != null) {
            return columnSelectionMode.equalsIgnoreCase("single");
        }
        return false;
    }

    public void processDecodes(FacesContext context) {
        if (this.isDataManipulationRequest(context)) {
            this.decode(context);
            if (this.isSelectionEnabled()) {
                this.updateSelectionModel(context);
            }
            context.renderResponse();
        } else {
            super.processDecodes(context);
        }
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updateSelectionModel(context);
    }

    protected void updateSelectionModel(FacesContext context) {
        ValueExpression selectionVE = this.getValueExpression("selection");
        if (selectionVE != null) {
            Object value = this.emptySelected ? null : this.getSelection();
            selectionVE.setValue(context.getELContext(), value);
            this.setSelection(null);
        }
    }

    public void setEmptySelected(boolean emptySelected) {
        this.emptySelected = emptySelected;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext context = FacesContext.getCurrentInstance();
        String outcome = null;
        MethodExpression me = null;
        if (event instanceof SelectEvent) {
            me = this.getRowSelectListener();
        } else if (event instanceof UnselectEvent) {
            me = this.getRowUnselectListener();
        } else if (event instanceof RowEditEvent) {
            me = this.getRowEditListener();
        }
        if (me != null) {
            outcome = (String)me.invoke(context.getELContext(), new Object[]{event});
        }
        if (outcome != null) {
            NavigationHandler navHandler = context.getApplication().getNavigationHandler();
            navHandler.handleNavigation(context, null, outcome);
            context.renderResponse();
        }
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public boolean hasFooterColumn() {
        for (Column column : this.getColumns()) {
            if (column.getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    public void loadLazyData() {
        LazyDataModel model = (LazyDataModel)this.getDataModel();
        model.setPageSize(this.getRows());
        List data = model.load(this.getFirst(), this.getRows(), this.getSortField(), this.getSortOrder(), this.getFilters());
        model.setWrappedData(data);
    }

    public void clearLazyCache() {
        LazyDataModel model = (LazyDataModel)this.getDataModel();
        model.setWrappedData(null);
    }

    public String getSortField() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"sortField"), null);
    }

    public void setSortField(String sortField) {
        this.getStateHelper().put((Serializable)((Object)"sortField"), (Object)sortField);
    }

    public boolean getSortOrder() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)"sortOrder"), (Object)true);
    }

    public void setSortOrder(boolean sortOrder) {
        this.getStateHelper().put((Serializable)((Object)"sortOrder"), (Object)sortOrder);
    }

    public Map<String, String> getFilters() {
        return (Map)this.getStateHelper().eval((Serializable)((Object)"filters"), new HashMap());
    }

    public void setFilters(Map<String, String> filters) {
        this.getStateHelper().put((Serializable)((Object)"filters"), filters);
    }

    public void addSelectedRowIndex(Integer rowIndex) {
        this.selectedRowIndexes.add(rowIndex);
    }

    public List<Integer> getSelectedRowIndexes() {
        return this.selectedRowIndexes;
    }

    public String getSelectedRowIndexesAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> iter = this.selectedRowIndexes.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public boolean isCellSelection() {
        String selectionMode = this.getSelectionMode();
        if (selectionMode != null) {
            return selectionMode.indexOf("cell") != -1;
        }
        return false;
    }

    public void resetValue() {
        this.setValue(null);
        this.setFiltered(false);
    }

    public void resetPagination() {
        this.setFirst(0);
        this.setPage(1);
    }

    public void reset() {
        this.resetValue();
        this.resetPagination();
    }

    public void calculatePage() {
        int numberOfPages;
        int rows = this.getRows();
        int currentPage = this.getPage();
        if (currentPage > (numberOfPages = (int)Math.ceil((double)this.getRowCount() * 1.0 / (double)rows)) && numberOfPages > 0) {
            currentPage = numberOfPages;
            this.setPage(currentPage);
            this.setFirst((currentPage - 1) * rows);
        }
    }

    public boolean isFiltered() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)"filtered"), (Object)false);
    }

    public void setFiltered(boolean filtered) {
        this.getStateHelper().put((Serializable)((Object)"filtered"), (Object)filtered);
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void handleAttribute(String name, Object value) {
        String cname;
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = this.getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            ValueExpression ve = this.getValueExpression(name);
            if (ve == null) {
                setAttributes.remove(name);
            } else if (!setAttributes.contains(name)) {
                setAttributes.add(name);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        paginator,
        paginatorTemplate,
        rowsPerPageTemplate,
        currentPageReportTemplate,
        pageLinks,
        paginatorPosition,
        paginatorAlwaysVisible,
        page,
        scrollable,
        height,
        selectionMode,
        selection,
        dynamic,
        lazy,
        rowIndexVar,
        emptyMessage,
        update,
        onRowSelectUpdate,
        rowSelectListener,
        rowUnselectListener,
        onRowUnselectUpdate,
        style,
        styleClass,
        onselectStart,
        onselectComplete,
        onRowSelectStart,
        onRowSelectComplete,
        dblClickSelect,
        liveScroll,
        rowStyleClass,
        rowEditListener,
        onRowEditUpdate,
        onExpandStart;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

