/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    @Override
    public void export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int numberOfColumns = columns.size();
        if (preProcessor != null) {
            preProcessor.invoke(facesContext.getELContext(), new Object[]{wb});
        }
        this.addColumnHeaders(sheet, columns);
        int first = pageOnly ? table.getFirst() : 0;
        int size = pageOnly ? first + table.getRows() : table.getRowCount();
        int sheetRowIndex = 1;
        for (int i = first; i < size; ++i) {
            table.setRowIndex(i);
            HSSFRow row = sheet.createRow(sheetRowIndex++);
            for (int j = 0; j < numberOfColumns; ++j) {
                UIColumn column = columns.get(j);
                if (!column.isRendered()) continue;
                this.addColumnValue(row, column.getChildren(), j);
            }
        }
        table.setRowIndex(-1);
        if (postProcessor != null) {
            postProcessor.invoke(facesContext.getELContext(), new Object[]{wb});
        }
        this.writeExcelToResponse((HttpServletResponse)facesContext.getExternalContext().getResponse(), wb, filename);
    }

    private void addColumnHeaders(HSSFSheet sheet, List<UIColumn> columns) {
        HSSFRow rowHeader = sheet.createRow(0);
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (!column.isRendered()) continue;
            this.addColumnValue(rowHeader, column.getHeader(), i);
        }
    }

    private void addColumnValue(HSSFRow rowHeader, UIComponent component, int index) {
        HSSFCell cell = rowHeader.createCell(index);
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        cell.setCellValue(new HSSFRichTextString(value));
    }

    private void addColumnValue(HSSFRow rowHeader, List<UIComponent> components, int index) {
        HSSFCell cell = rowHeader.createCell(index);
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        cell.setCellValue(new HSSFRichTextString(builder.toString()));
    }

    private void writeExcelToResponse(HttpServletResponse response, HSSFWorkbook generatedExcel, String filename) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + filename + ".xls");
        generatedExcel.write((OutputStream)response.getOutputStream());
    }
}

