/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.growl;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.growl.Growl;
import org.primefaces.renderkit.CoreRenderer;

public class GrowlRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Iterator messages;
        ResponseWriter writer = facesContext.getResponseWriter();
        Growl growl = (Growl)component;
        String clientId = growl.getClientId(facesContext);
        writer.startElement("span", (UIComponent)growl);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.endElement("span");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        Iterator iterator = messages = growl.isGlobalOnly() ? facesContext.getMessages(null) : facesContext.getMessages();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            String severityImage = this.getImage(facesContext, growl, message);
            String summary = message.getSummary().replaceAll("'", "\\\\'");
            String detail = message.getDetail().replaceAll("'", "\\\\'");
            writer.write("jQuery.gritter.add({");
            if (growl.isShowSummary() && growl.isShowDetail()) {
                writer.write("title:'" + summary + "',text:'" + detail + "'");
            } else if (growl.isShowSummary() && !growl.isShowDetail()) {
                writer.write("title:'" + summary + "',text:''");
            } else if (!growl.isShowSummary() && growl.isShowDetail()) {
                writer.write("title:'',text:'" + detail + "'");
            }
            if (!this.isValueBlank(severityImage)) {
                writer.write(",image:'" + severityImage + "'");
            }
            if (growl.isSticky()) {
                writer.write(",sticky:true");
            } else {
                writer.write(",sticky:false");
            }
            if (growl.getLife() != 6000) {
                writer.write(",time:" + growl.getLife());
            }
            writer.write("});");
            message.rendered();
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected String getImage(FacesContext facesContext, Growl growl, FacesMessage message) {
        FacesMessage.Severity severity = message.getSeverity();
        if (severity == null) {
            return "";
        }
        if (severity.equals(FacesMessage.SEVERITY_INFO)) {
            return growl.getInfoIcon() != null ? this.getResourceURL(facesContext, growl.getInfoIcon()) : this.getResourceRequestPath(facesContext, "growl/assets/info.png");
        }
        if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
            return growl.getErrorIcon() != null ? this.getResourceURL(facesContext, growl.getErrorIcon()) : this.getResourceRequestPath(facesContext, "growl/assets/error.png");
        }
        if (severity.equals(FacesMessage.SEVERITY_WARN)) {
            return growl.getWarnIcon() != null ? this.getResourceURL(facesContext, growl.getWarnIcon()) : this.getResourceRequestPath(facesContext, "growl/assets/warn.png");
        }
        if (severity.equals(FacesMessage.SEVERITY_FATAL)) {
            return growl.getFatalIcon() != null ? this.getResourceURL(facesContext, growl.getFatalIcon()) : this.getResourceRequestPath(facesContext, "growl/assets/fatal.png");
        }
        return "";
    }
}

