/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imageswitch;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.imageswitch.ImageSwitch;
import org.primefaces.renderkit.CoreRenderer;

public class ImageSwitchRenderer
extends CoreRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ImageSwitch imageSwitch = (ImageSwitch)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = imageSwitch.getClientId(facesContext);
        writer.startElement("div", (UIComponent)imageSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (imageSwitch.getStyle() != null) {
            writer.writeAttribute("style", (Object)imageSwitch.getStyle(), null);
        }
        if (imageSwitch.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)imageSwitch.getStyleClass(), null);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ImageSwitch imageSwitch = (ImageSwitch)component;
        String clientId = imageSwitch.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        int slideshowSpeed = imageSwitch.isSlideshowAuto() ? imageSwitch.getSlideshowSpeed() : 0;
        writer.endElement("div");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(imageSwitch.resolveWidgetVar() + " = new PrimeFaces.widget.ImageSwitch('" + clientId + "',{");
        writer.write("fx:'" + imageSwitch.getEffect() + "'");
        writer.write(",speed:" + imageSwitch.getSpeed());
        writer.write(",timeout:" + slideshowSpeed);
        writer.write("});});");
        writer.endElement("script");
    }
}

