/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.comet;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;

public class PrimeFacesCometHandler
implements AtmosphereHandler {
    private static final Logger logger = Logger.getLogger(PrimeFacesCometHandler.class.getName());

    public void onRequest(AtmosphereResource event) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Handling comet event");
        }
        HttpServletRequest request = (HttpServletRequest)event.getRequest();
        HttpServletResponse response = (HttpServletResponse)event.getResponse();
        if (request.getMethod().equals("GET")) {
            response.setContentType("text/html;charset=ISO-8859-1");
            response.addHeader("Cache-Control", "private");
            response.addHeader("Pragma", "no-cache");
            event.suspend();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Client:\"{0}\" has subscribed", request.getRemoteAddr());
            }
        } else if (request.getMethod().equals("POST")) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Handling publish event request");
            }
            HashSet<AtmosphereResource> channelSubscribers = new HashSet<AtmosphereResource>();
            Iterator iterator = event.getBroadcaster().getAtmosphereResources();
            while (iterator.hasNext()) {
                String channelToBroadcast;
                AtmosphereResource resource = (AtmosphereResource)iterator.next();
                HttpServletRequest suspendedRequest = (HttpServletRequest)resource.getRequest();
                String subscribedChannel = suspendedRequest.getPathInfo().substring(1);
                if (!subscribedChannel.equalsIgnoreCase(channelToBroadcast = (String)request.getAttribute("primefacesCometChannel"))) continue;
                channelSubscribers.add(resource);
            }
            event.getBroadcaster().broadcast(request.getAttribute("primefacesPushEventMessage"), channelSubscribers);
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Lifecycle lifecycle = factory.getLifecycle("DEFAULT");
            lifecycle.render(FacesContext.getCurrentInstance());
        }
    }

    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        if (event.getMessage() == null) {
            return;
        }
        if (event.isCancelled()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Ignoring publishing cancelled event");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Publishing to subsciber.");
        }
        HttpServletRequest request = (HttpServletRequest)event.getResource().getRequest();
        HttpServletResponse response = (HttpServletResponse)event.getResource().getResponse();
        Object msg = event.getMessage();
        String jsonData = null;
        try {
            jsonData = this.isBean(msg) ? "{\"data\":" + new JSONObject(msg).toString() + "}" : new JSONObject().put("data", msg.toString()).toString();
        }
        catch (JSONException e) {
            throw new FacesException(e.getMessage());
        }
        String widget = request.getParameter("widget");
        String script = "<script type=\"text/javascript\">window.parent." + widget + ".handlePublish(" + jsonData + ");</script>";
        response.getWriter().write(script);
        response.getWriter().flush();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Publishing to \"{0}\" has completed", request.getRemoteAddr());
        }
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }
}

