/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menubutton;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menubutton.MenuButton;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.util.ComponentUtils;

public class MenuButtonRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        String buttonId = clientId + "_button";
        String menuId = clientId + "_menu";
        writer.startElement("span", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (button.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)button.getStyleClass(), "class");
        }
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "style");
        }
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)buttonId, null);
        writer.writeAttribute("name", (Object)buttonId, null);
        writer.writeAttribute("type", (Object)"button", null);
        if (button.getValue() != null) {
            writer.write(button.getValue());
        }
        writer.endElement("button");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)menuId, null);
        for (UIComponent child : button.getChildren()) {
            MenuItem item = (MenuItem)child;
            if (!item.isRendered()) continue;
            writer.startElement("li", (UIComponent)item);
            this.encodeMenuItem(context, item);
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuButton button = (MenuButton)abstractMenu;
        String clientId = button.getClientId(context);
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)button);
        if (form == null) {
            throw new FacesException("MenuButton : \"" + clientId + "\" must be inside a form element");
        }
        String formClientId = form.getClientId(context);
        writer.startElement("script", (UIComponent)button);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(button.resolveWidgetVar() + " = new PrimeFaces.widget.MenuButton('" + clientId + "', {");
        writer.write("animated:'" + button.getEffect() + "'");
        writer.write(",zindex:" + button.getZindex());
        if (button.getEffectDuration() != 400) {
            writer.write(",showDuration:" + button.getEffectDuration());
            writer.write(",hideDuration:" + button.getEffectDuration());
        }
        if (button.isDisabled()) {
            writer.write(",disabled:true");
        }
        writer.write("});");
        writer.endElement("script");
    }
}

