/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.terminal;

import java.io.IOException;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.terminal.Terminal;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TerminalRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Terminal terminal = (Terminal)component;
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(terminal.getClientId(facesContext))) {
            this.handleCommand(facesContext, component);
        } else {
            this.encodeMarkup(facesContext, terminal);
            this.encodeScript(facesContext, terminal);
        }
    }

    protected void encodeMarkup(FacesContext facesContext, Terminal terminal) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = terminal.getClientId(facesContext);
        writer.startElement("div", (UIComponent)terminal);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, Terminal terminal) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = terminal.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(terminal.resolveWidgetVar() + " = new PrimeFaces.widget.Terminal('" + clientId + "', {");
        writer.write("PS1:'" + terminal.getPrompt() + "'");
        writer.write(",id:'" + clientId + "'");
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",formId:'" + ComponentUtils.findParentForm(facesContext, (UIComponent)terminal).getClientId(facesContext) + "'");
        if (terminal.getWelcomeMessage() != null) {
            writer.write(",WELCOME_MESSAGE:'" + terminal.getWelcomeMessage() + "'");
        }
        if (terminal.getWidth() != null) {
            writer.write(",WIDTH:'" + terminal.getWidth() + "'");
        }
        if (terminal.getHeight() != null) {
            writer.write(",HEIGHT:'" + terminal.getHeight() + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void handleCommand(FacesContext facesContext, UIComponent component) throws IOException {
        String[] args;
        ResponseWriter writer = facesContext.getResponseWriter();
        Terminal terminal = (Terminal)component;
        String clientId = terminal.getClientId(facesContext);
        String argsParam = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + "_args");
        String[] tokens = argsParam.split(",");
        String command = tokens[0];
        if (tokens.length > 1) {
            args = new String[tokens.length - 1];
            for (int t = 1; t < tokens.length; ++t) {
                args[t - 1] = tokens[t];
            }
        } else {
            args = new String[]{};
        }
        MethodExpression commandHandler = terminal.getCommandHandler();
        String result = (String)commandHandler.invoke(facesContext.getELContext(), new Object[]{command, args});
        writer.write(result);
    }
}

