package net.ozar.egitim.jsf.kurlar.managed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ApplicationScoped;
import javax.faces.context.FacesContext;
import net.ozar.egitim.jsf.kurlar.pojo.DovizKur;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONObject;

/**
 * @author Gökhan Ozar
 * http://gokhan.ozar.net
 */
@ManagedBean
@ApplicationScoped
public class DovizKurlariBean implements java.io.Serializable {
    
    /*
     * Ersin Koç'un örnek döviz kur uygulamasından esinlenilmiştir
     * http://www.ersinkoc.com
     */

    private static final String KURURL = "http://www.doviz.gen.tr/doviz_json.asp?version=1.2";
    private static final String HAKKINDA = "     <br />Bu uygulama JSF 2, PrimeFaces 2 (Web 2.0 & AJAX) ve JSON nesnesi işleme ile ilgili bir örnek teşkil etmesi için hazırlanmıştır. Daha fazla bilgi için <a href=\"http://gokhan.ozar.net\">http://gokhan.ozar.net</a> sitesini ziyaret edebilirsiniz...  <br />";
    
    private DovizKur kur = new DovizKur();
    private String msj = HAKKINDA;

    public DovizKurlariBean() {
    }

    @PostConstruct
    public void kurlariYukle() {
        // System.out.println("Kurlar yükleniyor...");
        HttpClient webIstemci = new DefaultHttpClient();
        HttpGet webdenGetir = new HttpGet(KURURL);
        HttpResponse donenCevap;

        try {
            donenCevap = webIstemci.execute(webdenGetir);
            HttpEntity birim = donenCevap.getEntity();
            if (birim != null) {
                InputStream gelenVeri = birim.getContent();
                String sonuc = convertStreamToString(gelenVeri);

                JSONObject json = new JSONObject(sonuc);
                
                msj = json.getString("guncelleme").concat(HAKKINDA);
                
                kur.setDolarAlis     (json.getString("dolar" ));
                kur.setDolarSatis    (json.getString("dolar2"));
                kur.setEuroAlis      (json.getString("euro"  ));
                kur.setEuroSatis     (json.getString("euro2" ));
                kur.setSonGuncelleme (json.getString("sonkayit").concat(HAKKINDA).replaceAll("\\<.*?\\>", "")); // HTML etiketlerini kaldiriyoruz.
                kur.setMesaj         (msj); 
                 
                FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_INFO, msj, msj);
                FacesContext.getCurrentInstance().addMessage("successInfo", facesMsg);
                
                gelenVeri.close();
            }
        } catch (Exception e) {
            msj= "Kurları almaya çalışırken bir hata oldu!\nSunucu bağlantısında bir problem olabilir!";
            kur.setMesaj(msj);
            Logger.getLogger(DovizKurlariBean.class.getName()).log(Level.ERROR, null, e);
            FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msj, msj);
            FacesContext.getCurrentInstance().addMessage(null, facesMsg);
        }

    }

    public String convertStreamToString(InputStream is) {
        // Gelen veri akışı bir String değişkeni içine atılır
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        } catch (IOException e) {
        } finally {
            try {
                is.close();
            } catch (IOException e) {
            }
        }
        return sb.toString();
    }
    

    public DovizKur getKur() {
        return kur;
    }

    public void setKur(DovizKur kur) {
        this.kur = kur;
    }
    
    

}
